local assets =
{
	Asset("ANIM", "anim/soul.zip"),
    Asset("ATLAS", "images/inventoryimages/soul.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("soul")
    inst.AnimState:SetBuild("soul")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "soul"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/soul.xml"
    inst:AddComponent("selfstacker")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	inst.Transform:SetScale(1.5, 1.5, 1.5)
    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("soul", fn, assets)